#include <iostream>
#include <cstdio>
#include <cmath>
#include <vector>
#include <string>
#include <map>
#include <set>
#include <algorithm>

using namespace std;

const int MAXN = 2005, MAXM = 200 * 1000 + 5;
int p[MAXN], q[MAXN], c[MAXN];
char used[MAXN];
vector<int> g0[MAXN], g[MAXN], gr[MAXN], ts;

void topsort(int v) {
    used[v] = true;
    for(size_t i = 0; i < g[v].size(); i++)
        if(!used[g[v][i]])
            topsort(g[v][i]);
    ts.push_back(v);
}

void col(int v, int comp) {
    c[v] = comp;
    for(size_t i = 0; i < gr[v].size(); i++)
        if(!c[gr[v][i]])
            col(gr[v][i], comp);
}

int main() {
    ios_base::sync_with_stdio(false);
    int n;
    cin >> n;
    for(int i = 0; i < n; i++) {
        int k;
        cin >> k;
        g0[i].resize(k);
        for(int j = 0; j < k; j++) {
            cin >> g0[i][j];
            g0[i][j]--;
        }
    }
    for(int i = 0; i < n; i++) {
        cin >> p[i];
        p[i]--;
        q[p[i]] = i;
    }
    for(int i = 0; i < n; i++)
        for(size_t j = 0; j < g0[i].size(); j++)
            if(g0[i][j] != p[i]) {
                g[i].push_back(q[g0[i][j]]);
                gr[q[g0[i][j]]].push_back(i);
            }
    for(int i = 0; i < n; i++)
        if(!used[i])
            topsort(i);
    int comp = 1;
    for(int i = n - 1; i >= 0; i--)
        if(!c[ts[i]])
            col(ts[i], comp++);
    for(int i = 0; i < n; i++) {
        vector<int> ans;
        ans.push_back(p[i]);
        for(size_t j = 0; j < g[i].size(); j++)
            if(c[i] == c[g[i][j]])
                ans.push_back(p[g[i][j]]);
        cout << ans.size() << ' ';
        for(size_t j = 0; j < ans.size(); j++)
            cout << ans[j] + 1 << ' ';
        cout << '\n';
    }
    return 0;
}
